import { world, system, ItemStack } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:shroomblossom_destroy', {
        onPlayerDestroy: (data) => {
            const block = data.block
            const player = data.player
            block.dimension.runCommand(`particle v360:shroomblossom ${Object.values(block.location).join(' ')} `)
            system.run(() => {
                block.dimension.runCommand(`loot spawn ${Object.values(block.location).join(' ')} loot shroomblossom_loot`)
            })
            if (player) {
                player.runCommand('effect @e[r=10] poison 15 1 true')
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:shroomblossom_interact', {
        onPlayerInteract: (data) => {
            const block = data.block;
            const player = data.player;
            const equipment = player.getComponent('equippable');
            const shroomblossomItem = new ItemStack('v360:shroomblossom_item', 1);
            const selectedItem = equipment.getEquipment('Mainhand');
            if (selectedItem?.typeId === 'minecraft:shears') {
                block.dimension.spawnItem(shroomblossomItem, block.location)
                block.setType('minecraft:air')
                player.runCommand('playsound mob.sheep.shear @a[r=20]')
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:shroomblossom_tick', {
        onTick: ({ block }) => {
            block.dimension.runCommand(`particle v360:shroomblossom_ambient_particle ${Object.values(block.location).join(' ')} `)
        }
    })
})